<?php defined('SYSPATH') or die('No direct script access.');

class Task_Filler_Client extends Minion_Task{
    protected function _execute(array $params){
	    $limit = 10000;
	    $counter = Helper::getCounter('fill_client');
	    $fields = ['id', 'cid0', 'cid1', 'prefix', 'version', 'net', 'system', 'ip', 'location', 'registered', 'lastactivity'];

	    $model = DB::select()
		    ->from('test')
		    ->where('id', '>', $counter)
		    ->limit($limit)
		    ->order_by('id')
		    ->execute('default')
	        ->as_array();

	    if(!empty($model)){
		    $clients = DB::insert('clients', $fields);
		    foreach ($model as $c) {
			    $name = $c['client'];
			    if(strlen($name) != 32){
				    $data = json_encode(Arr::extract($c, ['client']));
				    $gearman = Task_Helper::getAdminClient();
				    $gearman->setCompleteCallback(function($task) use(&$clients, &$fields, &$name, &$c){
					    if($task->data()){
						    $data = json_decode($task->data(), true);
						    $data['id'] = $c['id'];
						    $clients->values(Arr::extract($data, $fields));
					    }else{ /* hack for lost client */
						    $cid1 = DB::expr("x'".substr($name, 0, 16)."'::BIGINT AS cid1");
						    $cid0 = DB::expr("x'".str_pad(substr($name, -15), 16, '0', STR_PAD_LEFT)."'::BIGINT AS cid0");
						    $c = $this->getCid($cid1, $cid0, $c);
						    $clients->values(Arr::extract($c, $fields));
					    }
				    });
				    $gearman->addTask('ClientInfoByName', $data, null, md5($data));
				    $gearman->runTasks();
			    }else{
				    $cid1 = DB::expr("x'".substr($name, 0, 16)."'::BIGINT AS cid1");
				    $cid0 = DB::expr("x'".substr($name, -16)."'::BIGINT AS cid0");
				    $c = $this->getCid($cid1, $cid0, $c);
				    $clients->values(Arr::extract($c, $fields));
			    }
		    }

		    $clients->execute();
		    $last = end($model);
		    Helper::updCounter($last['id'], 'fill_client');
	    }

    }

	private function getCid($cid1, $cid0, $client){
		$cids = DB::select($cid1, $cid0)
			->execute()
			->as_array();
		$client['cid1'] = $cids[0]['cid1'];
		$client['cid0'] = $cids[0]['cid0'];
		return $client;
	}

}